@extends('layouts.app')

@section('title', 'Order Confirmation')

@section('content')
<div class="container mx-auto">
    <h1 class="text-2xl font-bold mb-4">Thank You for Your Order!</h1>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <p>Your order has been placed successfully. Below are the details:</p>

    <div class="mt-4">
        <h2 class="text-xl font-bold">Order Details</h2>
        <p><strong>Order Number:</strong> {{ $order->order_number }}</p>
        <p><strong>Total Amount:</strong> ${{ $order->total_amount }}</p>
        <p><strong>Placed At:</strong> {{ $order->placed_at }}</p>
    </div>

    <div class="mt-4">
        <h2 class="text-xl font-bold">Shipping Address</h2>
        <p>{{ $order->shipping_address }}</p>
    </div>

    <div class="mt-4">
        <a href="{{ route('orders.index') }}" class="btn btn-primary">View Your Orders</a>
    </div>
</div>
@endsection